# ValoFly Tether Systems Communication Library Examples

This examples show how ValoFly Tether Systems Communication Library TetherCom is linked to an application and used by it.

## Usage
TetherCom library is designed to be used in CMake projects as it is explained in library documentation.

Once added TetherCom library to CMake project, it is available for the target application.

### TetherCom
To get access to TetherCom members, its header has to be included:
```
#include <TetherCom/TetherCom.h>
```

To use TetherCom library in your application a new instance of its class object has to be created
```
VALOFLY::TetherCom tetherCom;
```

This object can establish communication to ValoFly Tether.Solutions ground station after configuration.
To establish communication port name of serial port has to be set is input parameter for `openConnection()` function:
```
tetherCom.openConnection(portName);
```
If no exception occured, connection is establish successfuly and communication functions to interact with tether ground station are available.

If your are not sure, which ports are available, it is possible to get a list of all available serial ports:
```
std::vector<std::string> serialDevListPort;
std::vector<std::string> serialDevListDesc;
std::vector<std::string> serialDevListHwID;
tetherCom.listSerialPorts(serialDevListPort, serialDevListDesc, serialDevListHwID)
```
Or print all available ports directly:
```
tetherCom.printSerialPortList();
```

Current status of Tether.Solutions ground station can get with:
```
VALOFLY::TetherCom::systemStatus status;
tetherCom.getSystemStatus(status);
```

A status structure can printed for example by:
```
tetherCom.print(status, std::cout);
```

To set a set of configuration parameters to the Tether.Solutions ground station, use for example:
```
VALOFLY::TetherCom::systemConfig config;
config.cableRetractionStartLength = 5; // m
config.cableRetractionTorque = 50;	// %
config.systemActivation = false; // true/false => on/off

tetherCom.setSystemConfig(config);
```

Or set single configuration parameters separate:
```
tetherCom.setCableRetractionStartLength(config.cableRetractionStartLength);

tetherCom.setCableRetractionTorque(config.cableRetractionTorque);

tetherCom.setSystemActivation(config.systemActivation);
```

To close established connection:
```
tetherCom.closeConnection();
```