
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# try to determine serial lib location as it is provided by TetherComLib package
if (EXISTS "${CMAKE_CURRENT_LIST_DIR}/../../../../serial")
    set(SERIAL_ROOT_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../../serial")
    set(CMAKE_PREFIX_PATH ${CMAKE_PREFIX_PATH} ${SERIAL_ROOT_DIR})
endif()

# add serial lib
include(CMakeFindDependencyMacro)
find_dependency(serial CONFIG REQUIRED)

include("${CMAKE_CURRENT_LIST_DIR}/TetherComTargets.cmake")
check_required_components("TetherCom")

SET(TetherCom_BUILD 3)
SET(TetherCom_BUILD_DATE 2021-06-24)
MESSAGE(STATUS "Add ValoFly Tether.Solutions Communication Library")
MESSAGE(STATUS "Library Build: 3")
MESSAGE(STATUS "Library Build Date: 2021-06-24")
MESSAGE(STATUS "Communication Protocol Version: 2.0.0")
MESSAGE(STATUS "Communication Protocol Build: 3")
