# ValoFly Tether Systems Communication Library

This cross-plattform library is designed to communicate with ValoFly Tether.Solutions ground stations. This library is written in modern C++ and uses C++ 11 standards.

TetherCom class provides common functions to interface with hardware devices like open, close connection, set and get parameters, configurations and system details of ValoFly Tether.Solutions ground stations. For simple integration to other C++ projects, TetherCom library is designed as CMake package.

To use TetherCom library, serial communication library by William Woodall and John Harrison ([Serial](https://github.com/wjwwood/serial)) is required. Serial communication library is already part of the pre-built packages of TetherCom library but has to be included as CMake find package in projects using TetherCom library.

TetherCom library package contains examples how to work with this library.

## Resources

 * Website: https://valofly.com
 * Interface documentation: https://docs.valofly.com/TetherComLib/latest/
 * Pre-built packages (contains pre-built dependecies):
   - win-64: [Windows 64-bit VC16 build](https://cdn.valofly.com/software/releases/win-64/TetherComLib-latest-win-64.zip)
   - linux-64: [Unix 64-bit gcc 8.3.0 build](https://cdn.valofly.com/software/releases/linux-64/TetherComLib-latest-linux-64.tar.bz2)
   - linux-aarch64: [Unix aarch64 64-bit gcc 8.3.0 build] (https://cdn.valofly.com/software/releases/linux-aarch64/TetherComLib-latest-linux-aarch64.tar.bz2)
   - linux-armv7: [GNU/Linux armv71 32-bit gcc 8.3.0 build] (https://cdn.valofly.com/software/releases/linux-armv7/TetherComLib-latest-linux-armv7.tar.bz2)
   - linux-armv6: [GNU/Linux armv61 32-bit gcc 8.3.0 build] (https://cdn.valofly.com/software/releases/linux-armv6/TetherComLib-latest-linux-armv6.tar.bz2)
   - linux-armv5: [GNU/Linux armv5 32-bit gcc 8.3.0 build] (https://cdn.valofly.com/software/releases/linux-armv5/TetherComLib-latest-linux-armv5.tar.bz2)
   
## Dependencies

Required:
  * CMake: https://cmake.org
  * Serial Communication Library: https://github.com/wjwwood/serial
  
## Package usage

TetherCom library is designed to be used with CMake projects.
Besides of TetherCom library, serial library has to be available for the project since TetherCom library link to it.

Place the library package consists of TetherCom library and serial library in a folder, where CMake and compiler can access them.
Set `TETHERCOM_ROOT_DIR` of `CMakeLists.txt` of your project to `/path/to/library_package/TetherComLib`, extend `CMAKE_PREFIX_PATH` with `TETHERCOM_ROOT_DIR` and use `find_package` for `TetherCom`.

If relations of both folder of TetherComLib and serial are still same as they delivered as package, TetherCom library will find path to serial library. If this will fail, path to serial library has to be configured by set `SERIAL_ROOT_DIR` to `/path/to/serial` and extend `CMAKE_PREFIX_PATH` with `SERIAL_ROOT_DIR`.

For example, supposed that library package is placed in `3rdParty` in project folder:
```
### TetherCom ###
set(TETHERCOM_ROOT_DIR "${PROJECT_SOURCE_DIR}/3rdParty/TetherComLib")
set(CMAKE_PREFIX_PATH ${CMAKE_PREFIX_PATH} ${TETHERCOM_ROOT_DIR})
find_package(TetherCom REQUIRED)
```
This example supposed, TetherCom library is able to determine location of serial lib.

In case of TetherComLib is not able to determine location of serial lib add its path to project configuration:
```
### serial ###
set(SERIAL_ROOT_DIR "/path/to/serial")
set(CMAKE_PREFIX_PATH ${CMAKE_PREFIX_PATH} ${SERIAL_ROOT_DIR})
```

Finaly CMake link targets have to be set with:
```
target_link_libraries(${TARGET_NAME} VALOFLY::TetherCom::TetherCom)
```
for TetherCom library.

It is not necessary to link serial library, but its path have to been known to CMake.

## Library usage

### TetherCom

To use ValoFly Tether.Solutions TetherCom library its header file has to be included to the developed software project, a new instance of `VALOFLY::TetherCom` object has to be initialized and a connection to ValoFly Tether:Solution ground station has to be opened with `VALOFLY::TetherCom::openConnection()`.

```
#include <TetherCom/TetherCom.h>

int main(int argc, char* argv[])
{    
	// new instance of TetherCom object which handle the connection to the tether ground station
	VALOFLY::TetherCom tetherCom;
    
    std::string portName = "/dev/ttyS0"; // or "COM5"
    
    // try to establish serial connection to tether ground station
	try
	{
		tetherCom.openConnection(portName);
	}
	catch (std::exception ex)
	{
		printf("%s", ex.what());
		return EXIT_FAILURE;
	}
	std::cout << "Open serial port \"" << portName << "\" successfull!" << std::endl;
```

For more details check example project included in TetherCom library package.

### TetherComDefinitions

Many status values of ValoFly Tether.Solution Ground Station are decoded as integer values. TetherComDefinitions header defines enum values for a better interpretation of received status values.
For a quick usage reference `Public communication definitions` of TetherCom.h can be enquire. At this part of the header file system status structs are initialized.

## License

### ValoFly TetherCom
ValoFly TetherCom library is under copyright (C) of ValoFly GmbH - All rights reserved

Unauthorized copying of any file of this software package, constists of source files, binary files, documentation, examples with its documentation and others, via any medium is prohibited.
It is allowed to use the libraries to create own software components by the user of the libraries. All resulting components using one or more libraries of these library package are strictly limited to used by the user/customer, who create the resulting software component.

It is strictly prohibited to sell, distribute or publish any product based on or constists of parts of one of the libraries of these library package in any way or via any medium without previous written permission.

### Serial Communication Library
Serial Communication Library is licensed under MIT License as it is described in the project source: [Serial license](https://github.com/wjwwood/serial#license)

### JSON Library
JSON Library is licensed under MIT License as it is described in the project source: [JSON license](https://github.com/nlohmann/json#license)